import { system, world } from "@minecraft/server";
import { CustomEntityBucketItems as CustomEntitySpawnEggs } from "../item/CustomEntityBucketItems.js";
export class AbstractSpawnEggEntity {
  constructor(identifier, spawnEggVariations) {
    this.identifier = identifier;
    this.spawnEggVariations = spawnEggVariations;
    this.onUseSpawnEgg();
  }
  onUseSpawnEgg() {
    world.afterEvents.itemUseOn.subscribe((e) => {
      system.run(() => {
        const player = e.source;
        const clickedBlock = e.block;
        const clickedFace = e.blockFace;
        if (clickedBlock.permutation.matches('minecraft:frame') || clickedBlock.permutation.matches('minecraft:glow_frame')) return;
        function getSpawnLocation() {
          if (clickedFace == "North") return { x: clickedBlock.x + 0.5, y: clickedBlock.y + 0.5, z: clickedBlock.z - 0.5 }
          if (clickedFace == "South") return { x: clickedBlock.x + 0.5, y: clickedBlock.y + 0.5, z: clickedBlock.z + 1.5 }
          if (clickedFace == "East") return { x: clickedBlock.x + 1.5, y: clickedBlock.y + 0.5, z: clickedBlock.z + 0.5 }
          if (clickedFace == "West") return { x: clickedBlock.x - 0.5, y: clickedBlock.y + 0.5, z: clickedBlock.z + 0.5 }
          if (clickedFace == "Up") return { x: clickedBlock.x + 0.5, y: clickedBlock.y + 1.0, z: clickedBlock.z + 0.5 }
          if (clickedFace == "Down") return { x: clickedBlock.x + 0.5, y: clickedBlock.y, z: clickedBlock.z + 0.5 }
        };
        const item = e.itemStack;
        let entitySpawned;
        if (
          !item.typeId.startsWith("sf_nba") ||
          !this.spawnEggVariations.names().find((egg) => egg === item.typeId)
        )
          return;
        if (this.spawnEggHasVariations()) {
          const variation = this.spawnEggVariations.getVariation(item.typeId);
          entitySpawned = player.dimension.spawnEntity(
            `${this.identifier}<minecraft:entity_spawned>`,
            getSpawnLocation()
          );
          entitySpawned.teleport(getSpawnLocation(), { keepVelocity: false, facingLocation: player.location });
          try {
            entitySpawned.triggerEvent(`sf_nba:set_variant_${variation}`);
          } catch(e) {}
        } else {
          entitySpawned = player.dimension.spawnEntity(
            `${this.identifier}<minecraft:entity_spawned>`,
            getSpawnLocation()
          );
          entitySpawned.teleport(getSpawnLocation(), { keepVelocity: false, facingLocation: player.location });
        }
      });
    });
  }
  spawnEggHasVariations() {
    return typeof this.spawnEggVariations === "function";
  }
}